% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_webinar_polls.R
\name{get_webinar_polls}
\alias{get_webinar_polls}
\title{Get Webinar Polls}
\usage{
get_webinar_polls(webinar_id, account_id, client_id, client_secret)
}
\arguments{
\item{webinar_id}{Zoom Webinar Id, typically an 11 digit number.}

\item{account_id}{Account Id granted by the Zoom developer app.}

\item{client_id}{Client Id granted by the Zoom developer app.}

\item{client_secret}{Client secret granted by the Zoom developer app.}
}
\value{
A data frame with poll results from a webinar.
}
\description{
Get the polls summary from a single webinar.
}
\examples{
\dontrun{
dat <- get_webinar_polls(webinar_id = "99911112222",
  your_account_id,
  your_client_id,
  your_client_secret)
}
}
\seealso{
See <https://marketplace.zoom.us/docs/api-reference/zoom-api/> for 
documentation on the Zoom API.
}
