








#[cfg(not(feature = "std"))]
use alloc::vec::Vec;
use std::mem::MaybeUninit;

use crate::imp_prelude::*;
use crate::low_level_util::AbortIfPanic;


impl<A, S> ArrayBase<S, Ix1>
where S: RawData<Elem = A>
{

    pub fn to_vec(&self) -> Vec<A>
    where
        A: Clone,
        S: Data,
    {
        if let Some(slc) = self.as_slice() {
            slc.to_vec()
        } else {
            crate::iterators::to_vec(self.iter().cloned())
        }
    }



    pub(crate) fn rotate1_front(&mut self)
    where S: DataMut
    {

        let mut lane_iter = self.iter_mut();
        let mut dst = if let Some(dst) = lane_iter.next() { dst } else { return };









        let guard = AbortIfPanic(&"rotate1_front: temporarily moving out of owned value");
        let mut slot = MaybeUninit::<A>::uninit();
        unsafe {
            slot.as_mut_ptr().copy_from_nonoverlapping(dst, 1);
            for elt in lane_iter {
                (dst as *mut A).copy_from_nonoverlapping(elt, 1);
                dst = elt;
            }
            (dst as *mut A).copy_from_nonoverlapping(slot.as_ptr(), 1);
        }
        guard.defuse();
    }
}
