% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/videoFaceAnalysis.R
\name{videoFaceAnalysis}
\alias{videoFaceAnalysis}
\title{Analyze the facial features within an exported Zoom video file}
\usage{
videoFaceAnalysis(
  inputVideo,
  recordingStartDateTime,
  sampleWindow,
  facesCollectionID = NA,
  videoImageDirectory = NULL,
  grabVideoStills = FALSE,
  overWriteDir = FALSE
)
}
\arguments{
\item{inputVideo}{string path to the video file (ideal is gallery)}

\item{recordingStartDateTime}{YYYY-MM-DD HH:MM:SS of the start of the recording}

\item{sampleWindow}{Frame rate for the analysis}

\item{facesCollectionID}{name of an 'AWS' collection with identified faces}

\item{videoImageDirectory}{path to a directory that either contains image files or where you want to save image files}

\item{grabVideoStills}{logical indicating whether you want the function to split the video file or not}

\item{overWriteDir}{logical indicating whether to overwrite videoImageDirectory if it exists}
}
\value{
data.frame with one record for every face detected in each frame. For each face, there is an abundance of information from 'AWS Rekognition'. This output is quite detailed. Note that there will be a varying number of faces per sampled frame in the video. Imagine that you have sampled the meeting and had someone rate each person's face within that sampled moment.
}
\description{
Using this function you can analyze attributes of facial expressions within
a video file. There are two ways to supply the video information. First, you
can provide the actual video file. The function will then break it down
into still frames using the grabVideoStills() function. Second, you can use
the videoImageDirectory argument to give the location of a directory where
images have been pre-saved.
}
\examples{
\dontrun{
vid.out = videoFaceAnalysis(inputVideo="meeting001_video.mp4", 
recordingStartDateTime="2020-04-20 13:30:00", 
sampleWindow=1, facesCollectionID="group-r",
videoImageDirectory="~/Documents/meetingImages", 
grabVideoStills=FALSE, overWriteDir=FALSE)
}
}
