% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processZoomTranscript.R
\name{processZoomTranscript}
\alias{processZoomTranscript}
\title{Process Zoom transcript file}
\usage{
processZoomTranscript(
  fname,
  recordingStartDateTime = "1970-01-01 00:00:00",
  languageCode = "en"
)
}
\arguments{
\item{fname}{String that is the path to the exported Zoom .vtt transcript chat file}

\item{recordingStartDateTime}{String that is the timestamp when the recording was started in YYYY-MM-DD HH:MM:SS}

\item{languageCode}{String denoting the language}
}
\value{
data.frame where each record is an utterance in the transcript, with columns:
\itemize{
\item utteranceId - Numeric identifier for each utterance in the transcript
\item utteranceStartSeconds - number of seconds from the start of the recording when utterance began
\item utteranceStartTime - POSIXct timestamp of the start of the utterance, using recordingStartDateTime as the zero
\item utteranceEndSeconds - number of seconds from the start of the recording when utterance ended
\item utteranceEndTime - POSIXct timestamp of the end of the utterance, using recordingStartDateTime as the zero
\item utteranceTimeWindow - number of seconds that this utterance lasted
\item userName - Zoom display name of the person who spoke this utterance
\item utteranceMessage - transcribed spoken words of this utterance
\item utteranceLanguage - language code for this utterance
}
}
\description{
Process Zoom transcript file
}
\section{Zoom Recording Transcript File Processing}{
This function parses the data from the transcript file (.vtt) that is downloaded from the Zoom website.
NOTE: This is the file that accompanies a recording to the cloud.
}

\examples{
tr.out = processZoomTranscript(
fname=system.file('extdata', 'meeting001_transcript.vtt', package = 'zoomGroupStats'), 
recordingStartDateTime = '2020-04-20 13:30:00', languageCode = 'en')
}
