% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grabVideoStills.R
\name{grabVideoStills}
\alias{grabVideoStills}
\title{Helper function to split a video into still frames}
\usage{
grabVideoStills(
  inputVideo,
  imageDir = NULL,
  overWriteDir = FALSE,
  sampleWindow
)
}
\arguments{
\item{inputVideo}{full filepath to a video file}

\item{imageDir}{the directory where you want the function to write the extracted image files}

\item{overWriteDir}{logical indicating whether you want to overwrite imageDir if it exists}

\item{sampleWindow}{an integer indicating how frequently you want to sample
images in number of seconds.}
}
\value{
a data.frame that gives information about the still frames. Each record is
a stillframe, with the following info:
\itemize{
\item imageSeconds - number of seconds from the start of the video when this image was captured
\item imageName - full path to where the image has been saved as a .png
}
}
\description{
This function currently relies on the av package and
'ffmpeg' to split a video file into images. This function will save
the images to the directory specified by the user.
}
\examples{
vidOut = grabVideoStills(inputVideo=system.file('extdata', "meeting001_video.mp4", 
package = 'zoomGroupStats'), imageDir=tempdir(), overWriteDir=TRUE, sampleWindow=2)
\dontrun{
grabVideoStills(inputVideo='myMeeting.mp4', 
imageDir="~/Documents/myMeetings/videoImages", overWriteDir=TRUE,  sampleWindow=45)
}
}
