% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zlog_df.R
\name{z_df}
\alias{z_df}
\alias{zlog_df}
\title{Calculate z/zlog Values for a data.frame}
\usage{
z_df(x, limits, probs = c(0.025, 0.975), log = FALSE)

zlog_df(x, limits, probs = c(0.025, 0.975))
}
\arguments{
\item{x}{\code{data.frame}, with the columns: "age", \code{numeric}, "sex", \code{factor}
and more user defined \code{numeric} columns that should be z/z(log) transformed.}

\item{limits}{\code{data.frame}, reference table, has to have the columns:
"age", \code{numeric} (same units as in \code{age}, e.g. days or years, age of \code{0}
matches all ages),
"sex", \code{factor} (same levels for male and female as \code{sex} and a special level
\code{"both"}), "param", \code{character} with the laboratory parameter name that have
to match the column name in \code{x}, "lower" and "upper", \code{numeric} for the
lower and upper reference limits.}

\item{probs}{\code{numeric}, probabilities of the lower and upper reference limit,
default: \code{c(0.025, 0.975)} (spanning 95 \%). Has to be of length 2 for
\code{numeric} or a two-column \code{matrix} with as many rows as elements in \code{x}.}

\item{log}{\code{logical}, should z (\code{log = FALSE}, default) or
z(log) (\code{log = TRUE}) calculated?}
}
\value{
\code{data.frame}, with the columns: "age", "sex" and all \code{numeric}
columns z/zlog transformed. If a column name is missing in \code{limits$param}
a warning is thrown and the column is set to \code{NA}.
}
\description{
Calculates the z or z(log) values for laboratory measurement standardisation
as proposed in Hoffmann 2017 et al. for a complete \code{data.frame}.
}
\details{
This is a wrapper function for \code{\link[=z]{z()}} and \code{\link[=lookup_limits]{lookup_limits()}}. Please find
the details for the z/z(log) calculation at \code{\link[=z]{z()}}.

\code{zlog_df} is an alias for \code{z_df(..., log = TRUE)}.
}
\examples{
l <- data.frame(
    param = c("alb", "bili"),
    age = c(0, 0),
    sex = c("both", "both"),
    units = c("mg/l", "µmol/l"),
    lower = c(35, 2),
    upper = c(52, 21)
)
x <- data.frame(
    age = 40:48,
    sex = rep(c("female", "male"), c(5, 4)),
    # from Hoffmann et al. 2017
    alb = c(42, 34, 38, 43, 50, 42, 27, 31, 24),
    bili = c(11, 9, 2, 5, 22, 42, 37, 200, 20)
)
z_df(x, l)

zlog_df(x, l)
}
\references{
Georg Hoffmann, Frank Klawonn, Ralf Lichtinghagen, and Matthias Orth.
2017.
"The Zlog-Value as Basis for the Standardization of Laboratory Results."
LaboratoriumsMedizin 41 (1): 23–32.
\doi{10.1515/labmed-2016-0087}.
}
\seealso{
\code{\link[=zlog]{zlog()}}
}
\author{
Sebastian Gibb
}
