% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zcol.R
\name{zcol}
\alias{zcol}
\title{Z(log) Depending Color}
\usage{
zcol(x)
}
\arguments{
\item{x}{\code{numeric}, z(log) value.}
}
\value{
\code{character}, of \code{length(x)} with the corresponding color hex code.
}
\description{
This function provides a color gradient depending on the zlog value as
described in Hoffmann et al. 2017. The colours are only roughly equal to the
one found in the article.
}
\examples{
z <- -10:10
image(matrix(z, ncol = 1), col = zcol(z), xaxt = "n", yaxt = "n")
text(seq(0, 1, length.out=length(z)), 0, label = z)
}
\references{
Hoffmann, Georg, Frank Klawonn, Ralf Lichtinghagen, and Matthias Orth.
2017.
"The Zlog-Value as Basis for the Standardization of Laboratory Results."
LaboratoriumsMedizin 41 (1): 23–32. \doi{10.1515/labmed-2016-0087}.
}
\author{
Sebastian Gibb
}
