% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zi_load_crosswalk.R
\name{zi_load_crosswalk}
\alias{zi_load_crosswalk}
\title{Load Crosswalk Files}
\usage{
zi_load_crosswalk(zip_source = "UDS", year, qtr = NULL, target = NULL,
    query = NULL, key = NULL)
}
\arguments{
\item{zip_source}{Required character scalar; specifies the source of ZIP Code
crosswalk data. This can be one of either \code{"UDS"} (default) or
\code{"HUD"}.}

\item{year}{Required four-digit numeric scalar for year; varies based on source.
For \code{"UDS"}, years 2009 through 2023 are available. For \code{"HUD"},
years 2010 through 2024 are available.}

\item{qtr}{Numeric scalar, required when \code{zip_code} is \code{"HUD"}.
Integer value between 1 and 4, representing the quarter of the year.}

\item{target}{Character scalar, required when \code{zip_code} is \code{"HUD"}.
Can be one of \code{"TRACT"}, \code{"COUNTY"}, \code{"CBSA"},
\code{"CBSADIV"}, \code{"CD"}, and \code{"COUNTYSUB"}.}

\item{query}{Scalar or vector, required when \code{zip_code} is \code{"HUD"}.
This can be a five-digit numeric or character ZIP Code, a vector of
ZIP Codes, a two-letter character state abbreviation, or \code{"all"}.}

\item{key}{Optional when \code{zip_code} is \code{"HUD"}. This should be a
character string containing your HUD API key. Alternatively, it can be
stored in your \code{.RProfile} as \code{hud_key}.}
}
\value{
A tibble containing the crosswalk file.
}
\description{
Spatial data on USPS ZIP Codes are not published by the U.S.
    Postal Service or the U.S. Census Bureau. Instead, ZIP Codes can be
    converted to a variety of Census Bureau geographies using crosswalk files.
    This function reads in ZIP Code to ZIP Code Tabulation Area (ZCTA) crosswalk
    files from the former UDS Mapper project, which was sunset by the American
    Academy of Family Physicians in early 2024. It also provides access to the
    U.S. Department of Housing and Urban Development's ZIP Code crosswalk files,
    which provide similar functionality for converting ZIP Codes to a variety
    of geographies including counties.
}
\examples{
\donttest{
 # former UDS mapper crosswalks
 zi_load_crosswalk(zip_source = "UDS", year = 2020)
}

\dontrun{
 # HUD crosswalks
 # you will need to replace INSERT_HUD_KEY with your own key
 ## ZIP Code to CBSA crosswalk for all ZIP Codes
 zi_load_crosswalk(zip_source = "HUD", year = 2023, qtr = 1, target = "CBSA",
     query = "all", key = INSERT_HUD_KEY)

 ## ZIP Code to County crosswalk for all ZIP Codes in Missouri
 zi_load_crosswalk(zip_source = "HUD", year = 2023, qtr = 1, target = "COUNTY",
     query = "MO", key = INSERT_HUD_KEY)

 ## ZIP Code to Tract crosswalk for ZIP Code 63139 in St. Louis City
 zi_load_crosswalk(zip_source = "HUD", year = 2023, qtr = 1, target = "TRACT",
     query = 63139, key = INSERT_HUD_KEY)
}

}
