% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deposit_stats.R
\name{deposit_stats}
\alias{deposit_stats}
\title{Fetch statistics from one or more Zenodo deposits}
\usage{
deposit_stats(deposit_ids, all_versions_only = FALSE, progress = TRUE)
}
\arguments{
\item{deposit_ids}{vector. A vector of Zenodo deposit ids.}

\item{all_versions_only}{logical. If \code{TRUE}, return only the results for all versions.}

\item{progress}{logical. Show a progress bar.}
}
\value{
a tibble.
}
\description{
This function will fetch statistics from multiple deposits, respecting web crawling policies from Zenodo's 'robots.txt' file.
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
deposit_stats(c(10013255, 10889682), all_versions_only = TRUE)
\dontshow{\}) # examplesIf}
}
