% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndjson.R
\name{write_ndjson_file}
\alias{write_ndjson_file}
\title{Write list or data.frame object to NDJSON in a file}
\usage{
write_ndjson_file(x, filename, opts = list(), ...)
}
\arguments{
\item{x}{\code{data.frame} or \code{list} to be written as multiple JSON strings}

\item{filename}{JSON strings will be written to this file one-line-per-JSON string.}

\item{opts}{Named list of serialization options. Usually created by \code{\link[=opts_write_json]{opts_write_json()}}}

\item{...}{Other named options can be used to override any options in \code{opts}.
The valid named options are identical to arguments to \code{\link[=opts_write_json]{opts_write_json()}}}
}
\value{
None
}
\description{
For \code{list} input, each element of the list is written as a single JSON string.
For \code{data.frame} input, each row of the \code{data.frame} is written
as aJSON string.
}
\examples{
tmp <- tempfile()
write_ndjson_file(head(mtcars), tmp)
read_ndjson_file(tmp)
}
\seealso{
Other JSON Serializer: 
\code{\link{write_json_file}()},
\code{\link{write_json_raw}()},
\code{\link{write_json_str}()},
\code{\link{write_ndjson_raw}()},
\code{\link{write_ndjson_str}()}
}
\concept{JSON Serializer}
