% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json.R
\name{validate_json_file}
\alias{validate_json_file}
\alias{validate_json_str}
\title{Validate JSON in file or string}
\usage{
validate_json_file(filename, verbose = FALSE, opts = list(), ...)

validate_json_str(str, verbose = FALSE, opts = list(), ...)
}
\arguments{
\item{filename}{path to file containing JSON}

\item{verbose}{logical. If the JSON is not valid, should a warning be
shown giving details?}

\item{opts}{Named list of options for parsing. Usually created by \code{opts_read_json()}}

\item{...}{Other named options can be used to override any options in \code{opts}.
The valid named options are identical to arguments to \code{\link[=opts_read_json]{opts_read_json()}}}

\item{str}{character string containing JSON}
}
\value{
Logical value. TRUE if JSON validates as OK, otherwise FALSE
}
\description{
Validate JSON in file or string
}
\examples{
tmp <- tempfile()
write_json_file(head(iris, 3), tmp)
validate_json_file(tmp)
str <- write_json_str(iris)
validate_json_str(str)
}
