% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tickers.R
\name{get_tickers_info}
\alias{get_tickers_info}
\title{Get information for multiple tickers}
\usage{
get_tickers_info(
  tickers_obj,
  modules = "summaryProfile",
  output = c("tibble", "response", "request"),
  proxy = NULL
)
}
\arguments{
\item{tickers_obj}{A tickers object created with get_tickers()}

\item{modules}{Character vector of module names to retrieve. Default is "summaryProfile".
See section "Available Modules" for common options.}

\item{output}{The type of output to return. Can be "tibble" (default), "list" (raw parsed JSON),
"response" (httr2 response), or "request" (httr2 request).}

\item{proxy}{Optional proxy settings for the request.}
}
\value{
A list of information for each ticker
}
\description{
Retrieves company information from Yahoo Finance for multiple specified ticker symbols.
}
\details{
See \code{get_info} for more details on the company information.
}
\examples{
\dontrun{
tech_tickers <- get_tickers(c("AAPL", "MSFT", "GOOG"))
tech_info <- get_tickers_info(tech_tickers)
}
}
