% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/financials.R
\name{get_income_statement}
\alias{get_income_statement}
\title{Get income statement for a ticker}
\usage{
get_income_statement(
  ticker,
  freq = c("annual", "quarterly"),
  start = NULL,
  end = NULL,
  income_keys = NULL,
  pretty = TRUE,
  wide = TRUE,
  proxy = NULL,
  output = c("tibble", "response", "request")
)
}
\arguments{
\item{ticker}{A ticker object created with \code{get_tickers()} or a ticker symbol string}

\item{freq}{Frequency of data: "annual" or "quarterly" (default "annual")}

\item{start}{Start timestamp as date, datetime, or string (default EOY 2016)}

\item{end}{End timestamp as date, datetime, or string (default current timestamp)}

\item{income_keys}{Vector of specific income statement keys to include (default all)
See \code{valid_income_keys} for available options.}

\item{pretty}{Format column names to be more readable (default TRUE)}

\item{wide}{Return data in wide format with dates as columns (default TRUE).
If FALSE, returns data in long format with a date column.}

\item{proxy}{Optional proxy settings for the request}

\item{output}{Object to return. Can be "tibble", "response", or "request" (default "tibble")}
}
\value{
Either a tibble with income statement data, an httr2 response object, or an httr2 request object
depending on the value of the output argument.
}
\description{
Retrieves income statement data from Yahoo Finance for a specified ticker symbol.
Income statements show a company's revenues, expenses, and profits over a specific period.
}
\section{Available Income Keys}{


Examples:
\itemize{
\item TotalRevenue
\item GrossProfit
\item OperatingIncome
\item NetIncome
}

See \code{valid_income_keys} for a full list of available income keys.
}

\examples{
\dontrun{
apple <- get_tickers("AAPL")

# Get annual income statement
income_stmt <- get_income_statement(apple)

# Get quarterly income statement
quarterly_income <- get_income_statement(apple, freq = "quarterly")

# Get specific income statement items
revenue_income <- get_income_statement(apple,
  income_keys = c("TotalRevenue", "NetIncome")
)

# Get data for a specific time period
income_2020_2022 <- get_income_statement(apple,
  start = "2020-01-01",
  end = "2022-12-31"
)
}
}
