% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grnn.search_auc.R
\name{grnn.search_auc}
\alias{grnn.search_auc}
\title{Search for the optimal value of GRNN smoothing parameter based on AUC}
\usage{
grnn.search_auc(net, sigmas, nfolds = 4, seed = 1)
}
\arguments{
\item{net}{A GRNN object generated by grnn.fit()}

\item{sigmas}{A numeric vector to search for the best smoothing parameter}

\item{nfolds}{A scalar for the number of n-fold, 4 by default}

\item{seed}{The seed value for the n-fold cross-validation, 1 by default}
}
\value{
The list of all searching outcomes and the best outcome
}
\description{
The function \code{grnn.search_auc} searches for the optimal value of GRNN smoothing parameter by cross-validation.
It is applicable to the classification.
}
\examples{
data(iris, package = "datasets")
Y <- ifelse(iris[, 5] == "setosa", 1, 0)
X <- scale(iris[, 1:4])
gnet <- grnn.fit(x = X, y = Y)
grnn.search_auc(net = gnet, sigmas = c(3, 5, 7), nfolds = 2)
}
