% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyse_functions.R
\name{summary_xvg}
\alias{summary_xvg}
\title{summarize xvg data
compute basic summary statistics (mean, sd, min, median, max)
for each variable in one or more xvg_data objects.}
\usage{
summary_xvg(xvg_data, merge_results = FALSE)
}
\arguments{
\item{xvg_data}{a list of class 'xvg_data' or a list containing multiple 'xvg_data' objects, as returned by \code{read_xvg()}.}

\item{merge_results}{logical, whether to combine results from multiple objects (default: FALSE).
When TRUE, results will include a 'group' column identifying the source.}
}
\value{
a data.frame with columns:
\describe{
\item{group}{(Optional) Source identifier when processing multiple objects with merge_results=TRUE.}
\item{variable}{Name of the variable (column) in the xvg data.}
\item{mean}{Arithmetic mean of that variable.}
\item{sd}{Standard deviation.}
\item{min}{Minimum value.}
\item{median}{Median value.}
\item{max}{Maximum value.}
}
}
\description{
summarize xvg data
compute basic summary statistics (mean, sd, min, median, max)
for each variable in one or more xvg_data objects.
}
\examples{
path <- system.file("extdata/rmsd.xvg", package = "xvm")
xvg_data <- read_xvg(path)
summary_xvg(xvg_data)

}
