% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_functions.R
\name{read_xpm}
\alias{read_xpm}
\title{read xpm files}
\usage{
read_xpm(xpm_files)
}
\arguments{
\item{xpm_files}{a character vector containing paths to one or more xpm files.}
}
\value{
list with the following components:
\itemize{
\item data - Data frame containing matrix values with coordinates
\item title - Chart title extracted from xpm
\item legend - Legend text extracted from xpm
\item x_label - X-axis label extracted from xpm
\item y_label - Y-axis label extracted from xpm
\item color_map - Named list mapping color codes to hex values
\item color_values - Named list mapping color codes to numeric values
}
}
\description{
This function reads xpm (X PixMap) files, validates their existence,
and returns parsed data structures in a list format.
}
\details{
The function performs the following operations:
\enumerate{
\item Validates input type (must be character vector)
\item Checks for file existence and filters missing files with warnings
\item Reads valid files and parses them using \code{\link[=parse_xpm]{parse_xpm()}}
\item Returns aggregated results in a named list
}
}
\examples{
\donttest{
library(xvm)
# Retrieve the path to the example file included in the package
xpm_file_path <- system.file("extdata/gibbs.xpm", package = "xvm")
xpm_data <- read_xpm(xpm_file_path) # read the xpm file using read_xpm() function
names(xpm_data)
}
}
