% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xtwithin.R
\name{within_max}
\alias{within_max}
\title{Compute the maximum within-group for a panel data}
\usage{
within_max(data, variable, id = NULL, t = NULL, na.rm = FALSE)
}
\arguments{
\item{data}{A data.frame or pdata.frame object containing the panel data.}

\item{variable}{The variable for which the maximum within-group effect is calculated.}

\item{id}{(Optional) Name of the individual identifier variable.}

\item{t}{(Optional) Name of the time identifier variable.}

\item{na.rm}{Logical. Should missing values be removed? Default is FALSE.}
}
\value{
The maximum within-group effect.
}
\description{
This function computes the maximum within-group for a panel data.
}
\examples{
# Example using pdata.frame
data("Gasoline", package = "plm")
Gas <- pdata.frame(Gasoline, index = c("country", "year"), drop.index = TRUE)
within_max(Gas, variable = "lgaspcar")


# Using regular data.frame with id and t specified
data("Crime", package = "plm")
within_max(Crime, variable = "crmrte", id = "county", t = "year")

}
