% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/looInternal.R
\name{loo_internal}
\alias{loo_internal}
\alias{loo.i}
\alias{loo.i0}
\alias{loo.r}
\alias{loo.c}
\alias{loo.b}
\alias{loo.e.sym}
\alias{loo.e.skew}
\alias{loo.e0.sym}
\alias{loo.e0.skew}
\alias{loo.v}
\alias{loo.i.lf}
\alias{loo.i0.lf}
\title{Leave-one-out cross-validation for two-step kernel ridge regression}
\usage{
loo.i(Y, Hk, Hg, pred)

loo.i0(Y, Hk, Hg, pred)

loo.r(Y, Hk, Hg, ...)

loo.c(Y, Hk, Hg, ...)

loo.b(Y, Hk, Hg, ...)

loo.e.sym(Y, Hk, pred)

loo.e.skew(Y, Hk, pred)

loo.e0.sym(Y, Hk, pred)

loo.e0.skew(Y, Hk, pred)

loo.v(Y, Hk, ...)

loo.i.lf(Y, alpha, pred)

loo.i0.lf(Y, alpha, pred)
}
\arguments{
\item{Y}{the matrix with responses}

\item{Hk}{the hat matrix for the first kernel (rows of Y)}

\item{Hg}{the hat matrix for the second kernel (columns of Y)}

\item{pred}{the predictions}

\item{...}{added to allow for specifying pred even when not needed.}

\item{alpha}{a vector of length 4 with the alpha values from a
\code{\link{linearFilter}} model}
}
\value{
a matrix with the leave-one-out predictions
}
\description{
These functions implement different cross-validation scenarios for
two-step kernel ridge regression. It uses the shortcuts for
leave-one-out cross-validation.
}
\details{
These functions are primarily for internal use and hence not exported.
Be careful when using them, as they do not perform any sanity check
on the input. It is up to the user to make sure the input makes sense.
}
\seealso{
\code{\link{loo}} for the user-level function.
}
