% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_tskrr.R
\name{impute_tskrr}
\alias{impute_tskrr}
\title{Impute missing values in a label matrix}
\usage{
impute_tskrr(
  y,
  k,
  g = NULL,
  lambda = 0.01,
  testdim = TRUE,
  testlabels = TRUE,
  symmetry = c("auto", "symmetric", "skewed"),
  keep = FALSE,
  niter = 10000,
  tol = sqrt(.Machine$double.eps),
  start = mean(y, na.rm = TRUE),
  verbose = FALSE
)
}
\arguments{
\item{y}{a label matrix}

\item{k}{a kernel matrix for the rows}

\item{g}{an optional kernel matrix for the columns}

\item{lambda}{a numeric vector with one or two values for the
hyperparameter lambda. If two values are given, the first one is
used for the k matrix and the second for the g matrix.}

\item{testdim}{a logical value indicating whether symmetry
and the dimensions of the kernel(s) should be tested.
Defaults to \code{TRUE}, but for large matrices
putting this to \code{FALSE} will speed up the function.}

\item{testlabels}{a logical value indicating wether the row- and column
names of the matrices have to be checked for consistency. Defaults to
\code{TRUE}, but for large matrices putting this to \code{FALSE} will
speed up the function.}

\item{symmetry}{a character value with the possibilities
"auto", "symmetric" or "skewed". In case of a homogeneous fit, you
can either specify whether the label matrix is symmetric or
skewed, or you can let the function decide (option "auto").}

\item{keep}{a logical value indicating whether the kernel hat
matrices should be stored in the model object. Doing so makes the
model object quite larger, but can speed up predictions in
some cases. Defaults to \code{FALSE}.}

\item{niter}{an integer giving the maximum number of iterations}

\item{tol}{a numeric value indicating the tolerance for convergence of
the algorithm. It is the maximum sum of squared differences between
to iteration steps.}

\item{start}{a numeric value indicating the value with which NA's are
replaced in the first step of the algorithm. Defaults to 0.}

\item{verbose}{either a logical value, 1 or 2. \code{1} means "show the number
of iterations and the final deviation", \code{2} means "show the deviation
every 10 iterations". A value \code{TRUE} is read as \code{1}.}
}
\value{
A \code{tskrr} model of the class \code{\link{tskrrImputeHeterogeneous}} or \code{\link{tskrrImputeHomogeneous}} depending on whether or
not \code{g} has a value.
}
\description{
This function implements an optimization algorithm that allows
imputing missing values in the label matrix while fitting a
\code{tskrr} model.
}
\examples{

data(drugtarget)

naid <- sample(length(drugTargetInteraction), 30)
drugTargetInteraction[naid] <- NA

impute_tskrr(drugTargetInteraction, targetSim, drugSim)

}
