% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generics.R, R/getters_linearFilter.R
\name{alpha}
\alias{alpha}
\alias{na_removed}
\alias{getters_linearFilter}
\alias{mean.linearFilter}
\alias{mean,linearFilter-method}
\alias{colMeans,linearFilter-method}
\alias{rowMeans,linearFilter-method}
\alias{alpha,linearFilter-method}
\alias{na_removed,linearFilter-method}
\title{Getters for linearFilter objects}
\usage{
alpha(x)

na_removed(x)

\method{mean}{linearFilter}(x, ...)

\S4method{mean}{linearFilter}(x, ...)

\S4method{colMeans}{linearFilter}(x)

\S4method{rowMeans}{linearFilter}(x)

\S4method{alpha}{linearFilter}(x)

\S4method{na_removed}{linearFilter}(x)
}
\arguments{
\item{x}{a \code{linearFilter} object}

\item{...}{arguments passed to or from other methods.}
}
\value{
for \code{mean}: the mean of the original matrix

for \code{colMeans}: a numeric vector with the column means

for \code{rowMeans}: a numeric vector with the row means

for \code{alpha}: a numeric vector of length 4 with the alpha
values.

for \code{na_removed}: a logical value indicating whether
missing values were removed prior to the fitting of the filter.
}
\description{
These functions allow you to extract slots from objects of the
class \code{\link{linearFilter}}.
}
\examples{
data(drugtarget)
lf <- linear_filter(drugTargetInteraction, alpha = 0.25)
alpha(lf)
mean(lf)
colMeans(lf)
na_removed(lf)

}
