% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitted.R
\name{fitted.tskrr}
\alias{fitted.tskrr}
\alias{fitted.linearFilter}
\alias{fitted,tskrr-method}
\alias{fitted,linearFilter-method}
\title{extract the predictions}
\usage{
\method{fitted}{tskrr}(object, labels = TRUE, ...)

\method{fitted}{linearFilter}(object, ...)

\S4method{fitted}{tskrr}(object, labels = TRUE, ...)

\S4method{fitted}{linearFilter}(object, ...)
}
\arguments{
\item{object}{an object for which the extraction of model fitted values
is meaningful.}

\item{labels}{a logical value indicating whether the labels should
be shown. Defaults to TRUE}

\item{...}{arguments passed to or from other methods.}
}
\value{
a numeric matrix with the predictions
}
\description{
This functions extracts the fitted predictions from a
\code{\link[xnet:tskrr-class]{tskrr}} object or an object
inheriting from that class. The \code{xnet}
package provides an S4 generic for the function
\code{\link[=fitted]{fitted}}  from the package \code{stats},
and a method for \code{\link[xnet:tskrr-class]{tskrr}} objects.
}
\examples{

data(drugtarget)

mod <- tskrr(drugTargetInteraction, targetSim, drugSim)
pred <- fitted(mod)

}
