% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xml_fragment.R
\name{xml_doc}
\alias{xml_doc}
\title{Create an xml_fragment with a root element, (kind of tag)}
\usage{
xml_doc(root, ..., .attr = list(...))
}
\arguments{
\item{root}{the name of the root element}

\item{...}{additional attributes to add to the tag}

\item{.attr}{a list of additional attributes to add to the tag, overrides the \code{...} argument}
}
\value{
an \code{xml_fragment} with the root element
}
\description{
Create an xml_fragment with a root element, (kind of tag)
}
\examples{

tag("greeting", "hi", id = "hi")

tag("person", id = "1") / (tag("name", "John Doe") + tag("age", 35))

xml_fragment(person = frag(
  .attr = c(id = 1),
  name = "John Doe",
  age = 30
))   / tag("address", "Unknown")


a <- tag("person", id = 1) /
  xml_fragment(
    name ="John Doe",
    age = 30,
    address = frag(
      street = "123 Main St",
      city = "Springfield"
    )
  )

cat(as.character(a))
}
