## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, message=FALSE-----------------------------------------------------
library(xmap)
library(dplyr)

## ----nesting------------------------------------------------------------------
abc_xmap <- demo$abc_links |>
  as_xmap_tbl(lower, upper, share)
str(abc_xmap)

## -----------------------------------------------------------------------------
abc_xmap[1:4, ]

## -----------------------------------------------------------------------------
abc_xmap |>
  tidyr::unpack(dplyr::everything()) ## or

abc_xmap |>
  purrr::flatten_df()

## -----------------------------------------------------------------------------
abc_xmap |>
  dplyr::filter(.weight_by[[1]] != 1)

## -----------------------------------------------------------------------------
abc_xmap |>
  dplyr::group_by(.to) |>
  dplyr::summarise(".from({names(abc_xmap$.from)})" := paste(.from[[1]], collapse = ", "))

