% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_data.R
\name{add_data}
\alias{add_data}
\title{Add a range of data in a single pass.}
\usage{
add_data(py_obj, data, from_rows = FALSE, titles_from_data = FALSE)
}
\arguments{
\item{py_obj}{py_obj}

\item{data}{data}

\item{from_rows}{from_rows}

\item{titles_from_data}{titles_from_data}
}
\value{
An openpyxl Python object.
}
\description{
The default is to treat each column as a data series.
}
\examples{
\dontrun{
wb <- Workbook()
ws <- active(wb)

chart1 <- BarChart(
  type = "col",
 style = 10,
  title = "Bar Chart",
  shape = 4
) |>
  y_axis(title = "Test number") |>
  x_axis(title = "Sample length (mm)")

data <- Reference(ws, min_col=2, min_row=1, max_row=7, max_col=3)
cats <- Reference(ws, min_col=1, min_row=2, max_row=7)

chart1 |>
  add_data(data = data, titles_from_data = TRUE) |>
  set_categories(cats)
}

}
