% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaPermMutate.R
\name{xegaPermMutateGenekOptLK}
\alias{xegaPermMutateGenekOptLK}
\title{Mutate a gene (by a random Lin-Kernighan k-OPT move).}
\usage{
xegaPermMutateGenekOptLK(gene, lF)
}
\arguments{
\item{gene}{A Permutation.}

\item{lF}{Local configuration of the genetic algorithm.}
}
\value{
A Permutation.
}
\description{
\code{xegaPermMutateGenekOptLK} mutates a permutation.
}
\details{
This operator implements a random k-Opt move
         version of the Lin-Kernighan heuristic.
         
         A sequence of random 2-Opt moves, all of which improve 
         the result is executed.
}
\examples{
gene1<-xegaPermInitGene(lFxegaPermGene)
xegaPermDecodeGene(gene1, lFxegaPermGene)
gene<-xegaPermMutateGenekOptLK(gene1, lFxegaPermGene)
xegaPermDecodeGene(gene, lFxegaPermGene)
}
\references{
Lin, S. and Kernighan. B. W. (1973): 
            An Effective Heuristic Algorithm 
            for the Traveling-Salesman Problem.
            Operations Research, 21(2), pp. 791-812.
            <doi:10.1287/opre.21.2.498>
}
\seealso{
Other Mutation: 
\code{\link{xegaPermMutateGene2Opt}()},
\code{\link{xegaPermMutateGeneBestGreedy}()},
\code{\link{xegaPermMutateGeneGreedy}()},
\code{\link{xegaPermMutateGeneOrderBased}()},
\code{\link{xegaPermMutateGenekInversion}()},
\code{\link{xegaPermMutateMix}()}
}
\concept{Mutation}
