% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGpMutate.R
\name{xegaGpMutationFactory}
\alias{xegaGpMutationFactory}
\title{Configure the mutation function of a genetic algorithm.}
\usage{
xegaGpMutationFactory(method = "MutateGene")
}
\arguments{
\item{method}{String specifying the mutation function.}
}
\value{
Mutation function for genes.
}
\description{
\code{xegaGpMutationFactory()} implements the selection
             of one of the mutation functions in this
             package by specifying a text string.
             The selection fails ungracefully (produces
             a runtime error), if the label does not match.
             The functions are specified locally.

             Current support:

             \enumerate{
             \item "MutateGene" returns \code{xegaGpMutateAllGene()}.
             \item "MutateAllGene" returns \code{xegaGpMutateAllGene()}.
             \item "MutateFilterGene" returns \code{xegaGpMutateFilterGene()}.
             }
}
\examples{
Mutate<-xegaGpMutationFactory("MutateGene")
gene1<-xegaGpInitGene(lFxegaGpGene)
gene1
Mutate(gene1, lFxegaGpGene)
}
\seealso{
Other Configuration: 
\code{\link{xegaGpCrossoverFactory}()},
\code{\link{xegaGpInitGeneFactory}()}
}
\concept{Configuration}
