% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGeDecode.R
\name{xegaGeDecodeGeneFactory}
\alias{xegaGeDecodeGeneFactory}
\title{Configure the decoder function of a genetic algorithm.}
\usage{
xegaGeDecodeGeneFactory(method = "DecodeGene")
}
\arguments{
\item{method}{A string specifying a decoder for genes}
}
\value{
A decoder for genes.
}
\description{
\code{xegaGeDecodeGeneFactory()} implements the selection
             of one of a decoder function
             by specifying a text string.
             The selection fails ungracefully (produces
             a runtime error) if the label does not match.
             The functions are specified locally.

             Current support:

             \enumerate{
             \item "DecodeGene" returns \code{xegaGeDecodeGene()}. (Default).
             \item "DecodeGeneDT" returns \code{xegaGeDecodeGeneDT()}.
                   This decoder does not guarantee complete programs.
             }
}
\examples{
lFxegaGeGene$GeneMap<-xegaGeGeneMapFactory("Mod")
gene<-xegaGeInitGene(lFxegaGeGene)
DecodeGene<-xegaGeDecodeGeneFactory("DecodeGene")
DecodeGene(gene, lFxegaGeGene)
DecodeGeneDT<-xegaGeDecodeGeneFactory("DecodeGeneDT")
DecodeGeneDT(gene, lFxegaGeGene)
}
\seealso{
Other Configuration: 
\code{\link{xegaGeGeneMapFactory}()},
\code{\link{xegaGePrecisionFactory}()}
}
\concept{Configuration}
