% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivationTrees.R
\name{compatibleSubtrees}
\alias{compatibleSubtrees}
\title{Test the compatibility of subtrees.}
\usage{
compatibleSubtrees(n1, n2, maxdepth = 5, DepthBounded = TRUE)
}
\arguments{
\item{n1}{Attributed node of the root of subtree 1.}

\item{n2}{Attributed node of the root of subtree 2.}

\item{maxdepth}{Integer. Maximal derivation depth.}

\item{DepthBounded}{\itemize{
\item \code{TRUE}: Only subtrees 
       with the same root symbol that respect 
      the depth restrictions are compatible. 
\item \code{FALSE}: The depth restrictions are not 
                    checked.}}
}
\value{
\code{TRUE} or \code{FALSE}
}
\description{
\code{compatibleSubtrees()} tests the compatibility of two 
       subtrees.
}
\details{
\code{compatibleSubtrees()} tests the compatibility of two 
       subtrees:
       \enumerate{
     \item The root symbol of the two subtrees must be identical:
           \code{(n1$ID==n2$ID)}.
     \item The depth restrictions must hold:
         \enumerate{
             \item \code{depth(n1) + depth(subtree2) <= maxdepth+maxSPT}
             \item \code{depth(n2) + depth(subtree1) <= maxdepth+maxSPT} 
                } 
              maxSPT is the maximal number of derivations needed 
               to generate a complete derivation tree.}
}
\examples{
g<-compileBNF(booleanGrammar())
t1<-randomDerivationTree(g$Start, g)
t1anl<-treeANL(t1, g$ST)
t2<-randomDerivationTree(g$Start, g)
t2anl<-treeANL(t2, g$ST)
n1<-chooseNode(t1anl$ANL)
n2<-chooseNode(t2anl$ANL)
compatibleSubtrees(n1, n2)
compatibleSubtrees(n1, n2, maxdepth=1)
compatibleSubtrees(n1, n2, DepthBounded=FALSE)

}
\seealso{
Other Tree Operations: 
\code{\link{treeExtract}()},
\code{\link{treeInsert}()}
}
\concept{Tree Operations}
