% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conticnt.R
\name{conticnt}
\alias{conticnt}
\title{continuous counting}
\usage{
conticnt(x, cnt = FALSE, ...)
}
\arguments{
\item{x}{a vector or data frame.}

\item{cnt}{whether to count the number rows in each continuous groups.}

\item{...}{ignored}
}
\value{
A integer vector indicating the number of continuous identical elements in x.
}
\description{
It counts the number of continuous identical values.
}
\examples{
# example I
x1 = c(0,0,0, 1,1,1)
conticnt(x1)
conticnt(x1, cnt=TRUE)

x2 = c(1, 2,2, 3,3,3)
conticnt(x2)
conticnt(x2, cnt=TRUE)

x3 = c('c','c','c', 'b','b', 'a')
conticnt(x3)
conticnt(x3, cnt=TRUE)

# example II
dt = data.frame(c1=x1, c2=x2, c3=x3)
conticnt(dt, col=c('c1', 'c2'))
conticnt(dt, col=c('c1', 'c2'), cnt = TRUE)

}
