% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit-screen.R
\name{fit_screen}
\alias{fit_screen}
\alias{use_fit_screen}
\alias{html_dependency_fit_screen}
\title{Fit Slides to the Screen}
\usage{
use_fit_screen()

html_dependency_fit_screen()
}
\value{
An\code{htmltools::tagList()} with the fit-to-screen dependency, or an
\code{\link[htmltools:htmlDependency]{htmltools::htmlDependency()}}.
}
\description{
This extension resizes the slides to match the browser window height and
width. In other words, the slides are maximized to match the screen size.
The primary use case for this extension is for when you want to show your
slides in split screen, for example when demonstrating code in RStudio or
another window. To enable fit-to-screen, press \strong{Alt}/\strong{Option} + \strong{F} during the
slideshow. To disable, reload the slides.
}
\section{Functions}{
\itemize{
\item \code{use_fit_screen()}: Use the fit-to-screen extension in your xaringan slides.

\item \code{html_dependency_fit_screen()}: Returns an \code{\link[htmltools:htmlDependency]{htmltools::htmlDependency()}} with the fit
screen dependencies. Most users will want to use \code{use_fit_screen()}.

}}
\section{Usage}{
 To enable fit-to-screen, add the following code chunk to your
slides:

\if{html}{\out{<div class="sourceCode markdown">}}\preformatted{```\{r xaringan-fit-screen, echo=FALSE\}
xaringanExtra::use_fit_screen()
```
}\if{html}{\out{</div>}}

And then press \strong{Alt}/\strong{Option} + \strong{F} at any point during your slide show to
enable the extension.
}

\examples{
use_fit_screen()

}
