% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/x3p_shade_mask.R
\name{x3p_shade_mask}
\alias{x3p_shade_mask}
\title{Shade the mask of an x3p object to reflect its surface profile}
\usage{
x3p_shade_mask(
  x3p,
  colors = rev(c("#b12819", "#d7301f", "#e16457", "#ffffff", "#5186a2", "#175d82",
    "#134D6B")),
  freqs = c(0, 0.05, 0.25, 0.45, 0.55, 0.75, 0.95, 1)
)
}
\arguments{
\item{x3p}{object containing a 3d topographic surface}

\item{colors}{vector of colors}

\item{freqs}{vector of values corresponding to color frequency (turned into quantiles of the differenced values)}
}
\value{
x3p object with color-shaded mask
}
\description{
Apply color shading to the mask of a 3d topographic surface.
}
\examples{
\dontrun{
data(wire)
x3p <- wire
x3p_image(x3p, size = c(400, 400), zoom=0.8)
x3p_with <- x3p \%>\% x3p_shade_mask()
x3p_image(x3p_with, size = c(400, 400), zoom=0.8)

data(lea)
lea \%>\% x3p_shade_mask() \%>\% x3p_image()
lea \%>\% x3p_shade_mask(freqs = c(0, 0.05, 0.1, 0.3,0.7, 0.9, 0.95, 1)) \%>\% x3p_image()
}
}
