% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/x3p_rotate.R
\name{x3p_rotate}
\alias{x3p_rotate}
\alias{rotate_x3p}
\title{Rotate an x3p object}
\usage{
x3p_rotate(x3p, angle = 90)

rotate_x3p(x3p, angle = 90)
}
\arguments{
\item{x3p}{x3p object}

\item{angle}{rotate counter-clockwise by angle in degrees.}
}
\description{
Rotate the surface matrix and mask of an x3p object. Also adjust meta information.
}
\examples{
\dontrun{
logo <- x3p_read(system.file("csafe-logo.x3p", package = "x3ptools"))
color_logo <- png::readPNG(system.file("csafe-color.png", package="x3ptools"))
logoplus <- x3p_add_mask(logo, as.raster(color_logo))
dim(logoplus$surface.matrix)
dim(logoplus$mask)
x3p_image(logoplus, multiply=50, size = c(741, 419),zoom = 0.5)

logoplus60 <- x3p_rotate(x3p = logoplus, angle = 60)
dim(logoplus60$surface.matrix)
dim(logoplus60$mask)
x3p_image(logoplus60, multiply=50, size = c(741, 419),zoom = 0.75)
}
}
