% Generated by roxygen2: do not edit by hand
% Please edit documentation in src/process_to_wv.cpp, src/process_to_wv.h
\name{qn_to_wv}
\alias{qn_to_wv}
\title{Quantisation Noise (QN) to WV}
\usage{
qn_to_wv(q2, tau)
}
\arguments{
\item{q2}{A \code{double} corresponding to variance of drift}

\item{tau}{A \code{vec} containing the scales e.g. \eqn{2^{\tau}}{2^tau}}
}
\value{
A \code{vec} containing the wavelet variance of the QN.
}
\description{
This function compute the Haar WV of a Quantisation Noise (QN) process
}
\section{Process Haar Wavelet Variance Formula}{

The Quantization Noise (QN) process has a Haar Wavelet Variance given by:
\deqn{\nu _j^2\left( {{Q^2}} \right) = \frac{{6{Q^2}}}{{\tau _j^2}}}{nu[j]^2 = (6*Q2)/(tau[j]^2)}
}

