% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wpmf_methods.R
\name{wpmf_methods}
\alias{wpmf_methods}
\alias{summary.wpmf}
\alias{print.wpmf}
\alias{set_times.wpmf}
\alias{set_timescales.wpmf}
\alias{set_values.wpmf}
\alias{set_dat.wpmf}
\alias{set_wtopt.wpmf}
\alias{set_signif.wpmf}
\alias{get_times.wpmf}
\alias{get_timescales.wpmf}
\alias{get_values.wpmf}
\alias{get_dat.wpmf}
\alias{get_wtopt.wpmf}
\alias{get_signif.wpmf}
\title{Basic methods for the \code{wpmf} class}
\usage{
\method{summary}{wpmf}(object, ...)

\method{print}{wpmf}(x, ...)

\method{set_times}{wpmf}(obj, newval)

\method{set_timescales}{wpmf}(obj, newval)

\method{set_values}{wpmf}(obj, newval)

\method{set_dat}{wpmf}(obj, newval)

\method{set_wtopt}{wpmf}(obj, newval)

\method{set_signif}{wpmf}(obj, newval)

\method{get_times}{wpmf}(obj)

\method{get_timescales}{wpmf}(obj)

\method{get_values}{wpmf}(obj)

\method{get_dat}{wpmf}(obj)

\method{get_wtopt}{wpmf}(obj)

\method{get_signif}{wpmf}(obj)
}
\arguments{
\item{object, x, obj}{An object of class \code{wpmf}}

\item{...}{Not currently used. Included for argument consistency
with existing generics.}

\item{newval}{A new value, for the \code{set_*} methods}
}
\value{
\code{summary.wpmf} produces a summary of a \code{wpmf} object.
A \code{print.wpmf} method is also available. For \code{wpmf} objects, 
\code{set_*} and \code{get_*} methods are available for all slots,
i.e., \code{*} equal to \code{times}, \code{timescales}, \code{wtopt}, 
\code{values}, \code{dat}, and \code{signif}. The \code{set_*} methods just throw an 
error, to prevent breaking the consistency between the slots of a 
\code{wpmf} object.
}
\description{
Set, get, summary, and print methods for the \code{wpmf} class.
}
\examples{
times<-1:30 #generate time steps
#generate fake count data for 20 locations
dat<-matrix(rpois(20*length(times),20),nrow=20,ncol=length(times)) 
dat<-cleandat(dat=dat,times=times,clev=2)$cdat #detrend and demean
h<-wpmf(dat,times)
get_times(h)
summary(h)
print(h)

}
\seealso{
\code{\link{wpmf}}
}
\author{
Daniel Reuman, \email{reuman@ku.edu}
}
