% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errcheck_wavparam.R
\name{errcheck_wavparam}
\alias{errcheck_wavparam}
\title{Error check wavelet transform parameters}
\usage{
errcheck_wavparam(scale.min, scale.max.input, sigma, f0, times, callfunc)
}
\arguments{
\item{scale.min}{The smallest scale of fluctuation that will be examined. At least 2.}

\item{scale.max.input}{The largest scale of fluctuation that is guaranteed to be examined}

\item{sigma}{The ratio of each time scale examined relative to the next timescale. Should be greater than 1.}

\item{f0}{The ratio of the period of fluctuation to the width of the envelope. Defaults to 1.}

\item{times}{The times data were measured at, spacing 1}

\item{callfunc}{Function calling this one, for better error messaging}
}
\value{
\code{errcheck_wavparam} returns nothing but throws and error if the conditions are not met
}
\description{
Error check the parameters \code{scale.min}, \code{scale.max.input}, \code{sigma}, \code{f0}
}
\author{
Daniel Reuman, \email{reuman@ku.edu}
}
