% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MC_evaluate_definitions.R
\name{evaluate_definitions_v3}
\alias{evaluate_definitions_v3}
\title{Evaluate Standardized Monte Carlo Expressions}
\usage{
evaluate_definitions_v3(
  theta_star,
  definitions,
  std_map,
  sd_boot_list,
  sd_var_boot,
  path_std_map
)
}
\arguments{
\item{theta_star}{A matrix of Monte Carlo samples.}

\item{definitions}{A named list of parameter definitions (e.g., list(indirect := "a * b")).}

\item{std_map}{A named character vector mapping intercept labels (e.g., a1) to variable names (e.g., M1diff).}

\item{sd_boot_list}{A list of bootstrap SD samples for intercept variables.}

\item{sd_var_boot}{A list of bootstrap SD samples for variables involved in slope paths.}

\item{path_std_map}{A named list mapping path labels to a vector of (predictor, outcome) variable names.}
}
\value{
A data frame of R rows (simulations) * all parameters (standardized free + defined).
}
\description{
Evaluates user-defined parameters (defined via expressions)
and standardized free parameters from Monte Carlo simulated samples.
This version supports both intercept-based standardization and
path-based standardization.
}
\keyword{internal}
