% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pack.R
\name{pack}
\alias{pack}
\title{Pack values into a named list.}
\usage{
pack(..., .wrapr_private_var_env = parent.frame())
}
\arguments{
\item{...}{values to pack, these should be specified by name (not as constants).}

\item{.wrapr_private_var_env}{environment to evaluate in}
}
\value{
named list of values
}
\description{
This function packs values given by name into a named list.
}
\examples{

x <- 1
y <- 2
pack(x, y)  # list(x = 1, y = 2)

pack(a = x, y)  # list(a = 1, y = 2)

pack(a = 5, y)  # list(a = 5, y = 2)

pack(1, 2)  # list('1' = 1, '2' = 2)

v <- pack(x = 8, y = 9)  # list(x = 8, y = 9)
v -> unpack[x, y]
print(x)  # 8
print(y)  # 9

}
\seealso{
\code{\link{unpack}}
}
