% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoreProteinFragments.R
\name{scoreProteinFragments}
\alias{scoreProteinFragments}
\title{Scoring Of Identifications (For Multi-Protein Queries)}
\usage{
scoreProteinFragments(
  resTab,
  fragmInp = NULL,
  j = 2,
  useCol = c("orig", "precAA", "tailAA", "beg", "end", "ppmToPred", "obsInd", "predInd"),
  prefFragPat = NULL,
  contigTermFragWe = 0.5,
  returnCombined = TRUE,
  figDraw = TRUE,
  silent = FALSE,
  callFrom = NULL,
  debug = FALSE
)
}
\arguments{
\item{resTab}{(matrix or data.frame) identification results  (will use columns 'beg','end','orig','obsInd')}

\item{fragmInp}{(numeric vector or matrix) experimental m/z values, may include suppl col(s) to be considered for score (se argument 'j')}

\item{j}{(integer) which column of fragmInp has m/z values, the following column is assumed as peak-intensity}

\item{useCol}{(character) colnames from resTab to be used, 1st posiion must be present as column of 'resTab' and must represent name of original, used for splitting by proteins (eg original input protein sequence), will be passed to \code{scoreFragments}}

\item{prefFragPat}{(matrix) for preferential fragmentation rules (see \code{.prefFragPattern()})}

\item{contigTermFragWe}{(numeric, length=1) weight to add for terminal fragments (since they cannot match other fragments beyond the protein limits)}

\item{returnCombined}{(logical)}

\item{figDraw}{(logical) make additional figure}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}

\item{debug}{(logical) for bug-tracking: more/enhanced messages and intermediate objects written in global name-space}
}
\value{
This function returns a list with matrix $scaled (combined and indiv rescaled scores) and $raw (matching lines of 'resTab')
}
\description{
Make scoring for multiple protein queries: individual components :sameSite,contiguous,prefFragSite,logPeakHeight + combined (sum of scales 0->1)
}
\examples{
tab2 <- matrix(c("20","2","13","11","3","10","4", "PT","PE","EP","DE","PEP","IDE","PEPT", 
  rep(c("PEPTIDE","protP"),each=7), c("inter","Nter","Cter")[c(1,2,1,3,2,3,2)], 
  c(3,1,2,6,1,5,1, 4,2,3,7,3,7,4), "E",NA,"P","I",NA,"T",NA, "I","P","T",NA,"T",NA,"I", 
  c(1,6,6,20,7,19,8), c(-0.094312,-0.14707,-0.14707,0.08641,0.0084762,-0.10965,0.057087), 
  rep(2,7)), nrow=7, dimnames=list(NULL, c("predInd","seq","orig","origNa","ty","beg","end",
  "precAA","tailAA","obsInd","ppmToPred","mass")))
tab2 <- cbind(tab2, seqNa=paste0(tab2[,"origNa"],".",tab2[,"beg"],"-",tab2[,"end"]),Abundance=1)
rownames(tab2) <- paste0(tab2[,"origNa"],".", tab2[,"beg"],"", tab2[,"end"])
obsMassX <- cbind(a=c(199.1077,296.1605,397.2082,510.2922,625.3192),
  b=c(227.1026,324.1554,425.2031,538.2871,653.3141),
  x=c(729.2937,600.2511,503.1984,402.1507,289.0666),
  y=c(703.3145,574.2719,477.2191,376.1714,263.0874))

(outF <- scoreFragments(tab2, fragmInp=cbind(as.numeric(obsMassX), Abundance=1)))
(out <- scoreProteinFragments(tab2, fragmInp=cbind(as.numeric(obsMassX), Abundance=1)))

}
\seealso{
\code{\link{scoreFragments}}, \code{\link{identifyPepFragments}}
}
