% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modifFragmTabOutput.R
\name{modifFragmTabOutput}
\alias{modifFragmTabOutput}
\title{Change fragment identification output format (for biologists)}
\usage{
modifFragmTabOutput(
  datafr,
  addData = NULL,
  fuseC = c("precAA", "seq", "tailAA"),
  sep = ".",
  modifCol = "mod",
  replMod = cbind(old = "by", new = "i"),
  finCols = c("fraNa", "origNa", "beg", "end", "seq", "ty", "mod", "modSpec", "obsMass",
    "mass", "ppmToPred", "ambig", "runNo", "FDR", "sco4", "sc.prefFrag",
    "sc.chargeCatch", "sc.complemFra", "sc.sameSite", "logInt"),
  supFinCols = NULL,
  sortTable = "end",
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{datafr}{(data.frame) initial output from identifyPepFragments()}

\item{addData}{(matrix or data.frame) suppelemental data}

\item{fuseC}{(character) columns to exract preceeding and tailing AA to fuse with separator 'sep' to main sequence}

\item{sep}{(character) separator for concatenation}

\item{modifCol}{(character) default 'modif'}

\item{replMod}{(matrix) if names of modifications shoule be renamed : the columns 'old' and 'new' indicata how modifcations should be renamed}

\item{finCols}{(character) columns to retain for final output}

\item{supFinCols}{(character)}

\item{sortTable}{(character) sort output 1st by name, then by 'beg' or 'end'}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) addtional diagnostic messages}

\item{callFrom}{(character) allow easier tracking of message produced}
}
\value{
data.frame of reorganized identification results
}
\description{
Change fragment identification output to format better adopted for biologists
}
\examples{
protP <- c(protP="PEPTIDE")
obsMassX <- cbind(a=c(199.1077,296.1605,397.2082,510.2922,625.3192),
  b=c(227.1026,324.1554,425.2031,538.2871,653.3141),
  x=c(729.2937,600.2511,503.1984,402.1507,289.0666),
  y=c(703.3145,574.2719,477.2191,376.1714,263.0874))
rownames(obsMassX) <- c("E","P","T","I","D")      # all 1 & 7 ions not included
modTy1 <- list(basMod=c("b","y"), varMod=c("p","o","q"))
frag1 <- identifyPepFragments(ex=as.numeric(obsMassX), pe=protP, modTy=modTy1, 
  minFragSize=2, chargeCatchFilter=FALSE)
(frag1b <- if(length(unlist(frag1$identif)) >0) modifFragmTabOutput(frag1))
}
\seealso{
\code{\link{identifyPepFragments}}
}
