% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkModTy.R
\name{.checkModTy}
\alias{.checkModTy}
\title{Check Modification Type}
\usage{
.checkModTy(
  modTy,
  knownMods,
  phoDePho = c("p", "q"),
  modTyGr = c("basMod", "varMod"),
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{modTy}{(character) list of modification types to be considered}

\item{knownMods}{(character) optonal custom list of known modifications, default from \code{AAfragSettings(outTy="all")$knownMods}}

\item{phoDePho}{(character) names of modifications that may be de-phosphorylated}

\item{modTyGr}{(character) groups of modifications to consider (defaults used both 'basMod' and 'varMod')}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allows easier tracking of messages produced}
}
\value{
This function returns the corrected list of mixed of variable and fixed modifications ($basMod, $varMod and $varMo2)
}
\description{
Check Modification Type
}
\examples{
modTy1 <- list(basMod=c("b","y","h"),varMod=c("p","o","q"))
.checkModTy(modTy1, knownMods=c("a","b","h","o","p","q","y"))
}
\seealso{
\code{\link{AAfragSettings}}
}
