% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test2grp.R
\name{test2grp}
\alias{test2grp}
\title{t-test each line of 2 groups of data}
\usage{
test2grp(
  dat,
  questNo,
  useCol = NULL,
  grp = NULL,
  annot = NULL,
  ROTSn = 0,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{dat}{(matrix or data.frame) main data (may contain NAs)}

\item{questNo}{(integer) specify here which question, ie comparison should be adressed}

\item{useCol}{(integer or character)}

\item{grp}{(character or factor)}

\item{annot}{(matrix or data.frame)}

\item{ROTSn}{(integer) number of iterations ROTS runs (stabilization of reseults may be seen with >300)}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) display additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
This function returns a limma-type S3 object of class 'MArrayLM' (which can be accessed like a list); multiple testing correction types or modified testing by ROTS may get included ('p.value','FDR','BY','lfdr' or 'ROTS.BH')
}
\description{
\code{test2grp} performs t-test on two groups of data using \href{https://bioconductor.org/packages/release/bioc/html/limma.html}{limma},
this is a custom implementation of \code{\link[wrMisc]{moderTest2grp}} for proteomics.
The final obkect also includes the results without moderation by \code{limma} (eg BH-FDR in \code{$nonMod.BH}). 
Furthermore, there is an option to make use of package ROTS (note, this will increase the time of computatins considerably).
}
\examples{
set.seed(2018);  datT8 <- matrix(round(rnorm(800)+3,1), nc=8, dimnames=list(paste(
  "li",1:100,sep=""), paste(rep(LETTERS[1:3],c(3,3,2)),letters[18:25],sep="")))
datT8[3:6,1:2] <- datT8[3:6,1:2] +3   # augment lines 3:6 (c-f) 
datT8[5:8,5:6] <- datT8[5:8,5:6] +3   # augment lines 5:8 (e-h) 
grp8 <- gl(3,3,labels=LETTERS[1:3],length=8)
datL <- list(data=datT8, filt= wrMisc::presenceFilt(datT8,grp=grp8,maxGrpM=1,ratMa=0.8))
testAvB0 <- wrMisc::moderTest2grp(datT8[,1:6], gl(2,3))
testAvB <- test2grp(datL, questNo=1)
}
\seealso{
\code{\link[wrMisc]{moderTest2grp}}, \code{\link[wrMisc]{pVal2lfdr}}, \code{\link[stats]{t.test}}, \code{ROTS} from the Bioconductor package \href{https://www.bioconductor.org/packages/release/bioc/html/ROTS.html}{ROTS}
}
