% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elimCloseCoord.R
\name{elimCloseCoord}
\alias{elimCloseCoord}
\title{Eliminate close (overlapping) points (in x & y space)}
\usage{
elimCloseCoord(
  dat,
  useCol = 1:2,
  elimIdentOnly = FALSE,
  refine = 2,
  nDig = 3,
  callFrom = NULL,
  silent = FALSE
)
}
\arguments{
\item{dat}{matrix (or data.frame) with main numeric input}

\item{useCol}{(numeric) index for numeric columns of 'dat' to use/consider}

\item{elimIdentOnly}{(logical) if TRUE, eliminate real duplicated points only (ie identical values only)}

\item{refine}{(numeric) allows increasing stringency even further  (higher 'refine' .. more lines considered equal)}

\item{nDig}{(integer) number of significant digits used for rounding, if two 'similar' values are identical after this rounding the second will be eliminated.}

\item{callFrom}{(character) allows easier tracking of message(s) produced}

\item{silent}{(logical) suppress messages}
}
\value{
resultant matrix/data.frame
}
\description{
\code{elimCloseCoord} reduces number of rows in 'dat' by eliminating lines where x & y coordinates (columns of matrix '\code{dat}' defined by '\code{useCol}') are identical (overlay points) or very close.
The stringency for 'close' values may be fine-tuned using \code{nDig}), this function uses internally \code{\link{firstOfRepeated}}.
}
\examples{
da1 <- matrix(c(rep(0:4,5),0.01,1.1,2.04,3.07,4.5),nc=2); da1[,1] <- da1[,1]*99; head(da1)
elimCloseCoord(da1)
}
\seealso{
\code{\link{findCloseMatch}}, \code{\link{firstOfRepeated}}
}
