% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readCsvBatch.R
\name{.inspectHeader}
\alias{.inspectHeader}
\title{Inspect 'matr' and check if 1st line can be used/converted as header}
\usage{
.inspectHeader(
  matr,
  headNames = c("Plate", "Well", "StainA"),
  numericCheck = TRUE,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{matr}{(matrix or data.frame) main input to be instected}

\item{headNames}{(character) column-names t look for}

\item{numericCheck}{(logical) allows reducing complexity by drawing for very long x or y}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns a matrix vector or data.frame similar to input
}
\description{
This function inspects 'matr' and check if 1st line can be used/converted as header.
If colnames of 'matr' are either NULL or 'V1',etc the 1st row will be tested if it contains any of the elements (if not, 1st line won't be used as new colnames)
If 'numericCheck'=TRUE, all columns will be tested if they can be converted to numeric
}
\examples{
ma1 <- matrix(letters[1:6], ncol=3, dimnames=list(NULL,c("ab","Plate","Well")))
.inspectHeader(ma1) 

}
\seealso{
\code{\link[utils]{head}} for looking at first few lines
}
