% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combineReplFromListToMatr.R
\name{combineReplFromListToMatr}
\alias{combineReplFromListToMatr}
\title{Combine replicates from list to matrix}
\usage{
combineReplFromListToMatr(lst, silent = FALSE, debug = FALSE, callFrom = NULL)
}
\arguments{
\item{lst}{(list)  list of arrays (typically multi-parameter measures of micortiterplate data)}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
list of arrays now with same dimension of arrays (but shorter, since replicate-arrays were combined)
}
\description{
Suppose multiple measures (like multiple chanels) are taken for subjects and these measures are organized as groups in a list, 
like muliple parameters (= channels) or types of measurements (typically many paramters are recorded when screeinig compounds in microtiter plates).
Within one parameter/channel all replicate-data from separate list-entries ('lst') will get combined according to names of list-elements.
The function will trim any redundant text in names of list-elements, try to isolate separator (may vary among replicate-groups, but should be 1 character long).
eg names "hct116 1.1.xlsx" & "hct116 1.2.xlsx" will be combined as replicates, "hct116 2.1.xlsx" will be considered as new group.
}
\examples{
lst2 <- list(aa_1x=matrix(1:12,nrow=4,byrow=TRUE),ab_2x=matrix(24:13,nrow=4,byrow=TRUE))
combineReplFromListToMatr(lst2)
}
\seealso{
\code{\link{extr1chan}}, \code{\link{organizeAsListOfRepl}}
}
