% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantile_correlation.R
\name{quantile_correlation_analysis}
\alias{quantile_correlation_analysis}
\title{Quantile Correlation Analysis}
\usage{
quantile_correlation_analysis(x, y, quantiles, wf = "la8", J = 8, n_sim = 1000)
}
\arguments{
\item{x}{Numeric vector for the first time series.}

\item{y}{Numeric vector for the second time series.}

\item{quantiles}{Numeric vector of quantiles.}

\item{wf}{Wavelet family name.}

\item{J}{Decomposition level.}

\item{n_sim}{Number of simulations for confidence intervals.}
}
\value{
Data frame with quantile correlation estimates and confidence intervals for one pair of series.
}
\description{
Quantile Correlation Analysis
}
\examples{
data <- data.frame(x = rnorm(1000), y = rnorm(1000))
quantiles <- c(0.05, 0.5, 0.95)
result <- quantile_correlation_analysis(data$x, data$y, quantiles,n_sim=10)
head(result)
}
