% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ped_satplot.R
\name{ped_satplot}
\alias{ped_satplot}
\title{Temporal plot of pedigree}
\usage{
ped_satplot(
  plottable,
  famSpacing = 2,
  hsGroupSpacing = 2,
  xWhiteSpace = 100,
  xlabel = "Date",
  ylabel = "Animal",
  title = "",
  subtitle = "",
  LegendLabel = "Sex",
  xlegend = 0.2,
  ylegend = 0.94,
  text_size = 2.5,
  fam_label_size = 2
)
}
\arguments{
\item{plottable}{Data frame. Output of \code{\link[=plot_table]{plot_table()}} function.}

\item{famSpacing}{Y-axis spacing between families. Should be even number!}

\item{hsGroupSpacing}{Y-axis spacing between half-sib groups. Should be even number!}

\item{xWhiteSpace}{Spacing on the X-axis at the beginning and end of the plot.}

\item{xlabel}{X-axis label.}

\item{ylabel}{Y-axis label.}

\item{title}{Plot title.}

\item{subtitle}{Plot subtitle.}

\item{LegendLabel}{Title of the legend.}

\item{xlegend}{Horizontal position of the legend.}

\item{ylegend}{Vertical position of the legend.}

\item{text_size}{Plot text size.}

\item{fam_label_size}{Family label text size.}
}
\value{
A graphical representation of detected family members trough time.
}
\description{
Creates "capture" history plot of individuals
arranged by families included in data frame created by \code{\link[=plot_table]{plot_table()}} function.
}
\examples{
# Prepare the data for usage with plot_table() function.
# Get animal timespan data using the anim_timespan() function.
animal_ts <- anim_timespan(wolf_samples$AnimalRef,
  wolf_samples$Date,
  wolf_samples$SType,
  dead = c("Tissue")
)
# Add animal timespan to the sampledata
sampledata <- merge(wolf_samples, animal_ts, by.x = "AnimalRef", by.y = "ID", all.x = TRUE)
# Define the path to the pedigree data file.
path <- paste0(system.file("extdata", package = "wpeR"), "/wpeR_samplePed")
# Retrieve the pedigree data from the get_colony function.
ped_colony <- get_colony(path, sampledata, rm_obsolete_parents = TRUE, out = "FamAgg")
# Organize families and expand pedigree data using the org_fams function.
org_tables <- org_fams(ped_colony, sampledata, output = "both")
# Prepare data for plotting.
pt <- plot_table(plot_fams = 1,
  org_tables$fams,
  org_tables$ped,
  sampledata,
  deadSample = c("Tissue")
)

# Run the function.
# Get a temporal pedigree plot.
ped_satplot(plottable = pt)





}
