% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_import_functions.R
\name{as_muscle_stim}
\alias{as_muscle_stim}
\title{Create your own muscle_stim object}
\usage{
as_muscle_stim(x, type, sample_frequency, ...)
}
\arguments{
\item{x}{A \code{data.frame}. See Details for how it should be organized.}

\item{type}{Experiment type; must be one of: "workloop", "tetanus", or
"twitch."}

\item{sample_frequency}{Numeric value of the frequency at which samples were
recorded; must be in Hz. Please format as numeric, e.g. \code{10000} works
but \code{10000 Hz} does not}

\item{...}{Additional arguments that can be passed in as attributes. See
Details.}
}
\value{
An object of class \code{workloop}, \code{twitch}, or \code{tetanus},
all of which inherit class \code{muscle_stim}. These objects behave like
\code{data.frames} in most situations but also store metadata from the ddf
as attributes.

The \code{muscle_stim} object's columns contain:
\item{Time}{Time}
\item{Position}{Length change of the muscle, uncorrected for gear ratio}
\item{Force}{Force, uncorrected for gear ratio}
\item{Stim}{When stimulation occurs, on a binary scale}

In addition, the following information is stored in the \code{data.frame}'s
attributes:
\item{sample_frequency}{Frequency at which samples were collected}
\item{pulses}{Number of sequential pulses within a stimulation train}
\item{total_cycles_lo}{Total number of oscillatory cycles (assuming sine
wave trajectory) that the muscle experienced. Cycles are defined with respect
to initial muscle length (L0-to-L0 as opposed to peak-to-peak).}
\item{amplitude}{amplitude of length change (again, assuming sine wave
trajectory)}
\item{cycle_frequency}{Frequency of oscillations (again, assuming sine wave
trajectory)}
\item{units}{The units of measurement for each column in the
\code{data.frame}. This might be the most important attribute so please check
 that it makes sense!}
}
\description{
For use when data are not stored in .ddf format and you would like
to create a \code{muscle_stim} object that can be used by other workloopR
functions.
}
\details{
\code{muscle_stim} objects, which are required by (nearly) all
workloopR functions, are automatically created via \code{read_ddf()}. Should
you have data that are stored in a format other than .ddf, use this function
to create your own object of class \code{muscle_stim}.

The input \code{x} must be a \code{data.frame} that contains time series
of numeric data collected from an experiment. Each row must correspond to a
sample, and these columns (exact title matches) must be included: \cr
"Time" - time, recorded in seconds \cr
"Position" - instantaneous position of the muscle,
  preferably in millimeters \cr
"Force" - force, preferably in millinewtons \cr
"Stim" - whether stimulation has occurred. All entries must be either 0 (no
stimulus) or 1 (stimulus occurrence).

Additional arguments can be provided via \code{...}. For all experiment
types, the following attributes are appropriate: \cr
"units","header", "units_table",
"protocol_table", "stim_table",
"stimulus_pulses", "stimulus_offset",
"stimulus_width", "gear_ratio",
"file_id", or "mtime".

Please ensure that further attributes are appropriate to your experiment
type.

For workloops, these include:
"stimulus_frequency", "cycle_frequency",
"total_cycles", "cycle_def",
"amplitude", "phase",
and "position_inverted"

For twitches or tetanic trials:
"stimulus_frequency", and "stimulus_length"
}
\examples{

library(workloopR)

# import the workloop.ddf file included in workloopR
wl_dat <-read_ddf(system.file("extdata", "workloop.ddf",
                              package = 'workloopR'))


}
\seealso{
\code{\link{read_ddf}}

Other data import functions: 
\code{\link{get_wl_metadata}()},
\code{\link{read_analyze_wl_dir}()},
\code{\link{read_analyze_wl}()},
\code{\link{read_ddf_dir}()},
\code{\link{read_ddf}()}
}
\author{
Shreeram Senthivasan
}
\concept{data import functions}
