% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wflow_use_gitlab.R
\name{wflow_use_gitlab}
\alias{wflow_use_gitlab}
\title{Deploy site with GitLab}
\usage{
wflow_use_gitlab(
  username = NULL,
  repository = NULL,
  navbar_link = TRUE,
  protocol = "https",
  domain = "gitlab.com",
  project = "."
)
}
\arguments{
\item{username}{character (default: NULL). The GitLab account associated with
the GitLab repository. This is likely your personal GitLab username, but it
could also be the name of a GitLab Group you belong to. It will be
combined with the arguments \code{repository} and \code{domain} to
determine the URL of the new repository, e.g. the default is
https://gitlab.com/username/repository. It will be combined with the
arguments \code{repository}, \code{domain}, and \code{protocol} to
determine the URL for Git to use to push and pull from GitLab, e.g. the
default is https://gitlab.com/username/repository.git. If \code{username}
is not specified, \code{wflow_use_gitlab} will first attempt to guess it
from the current setting for the remote URL named "origin". If you haven't
previously configured a remote for this workflowr project (or you are
unsure what that means), then you should specify your GitLab username when
calling this function.}

\item{repository}{character (default: NULL). The name of the remote
repository on GitLab. If not specified, workflowr will guess the name of
the repository. First, it will check the current setting for the remote URL
named "origin". Second, it will use the name of the root directory of the
workflowr project.}

\item{navbar_link}{logical (default: TRUE). Insert a link to the GitLab
repository into the navigation bar.}

\item{protocol}{character (default: "https"). The protocol for communicating
with GitLab. Must be either "https" or "ssh".}

\item{domain}{character (default: "gitlab.com"). The domain of the remote
host. You only need to change this if you are using a custom GitLab
instance hosted by your organization. For example, "git.rcc.uchicago.edu"
is the domain for the GitLab instance hosted by the University of Chicago
Research Computing Center.}

\item{project}{character (default: ".") By default the function assumes the
current working directory is within the project. If this is not true,
you'll need to provide the path to the project directory.}
}
\value{
Invisibly returns a list of class \code{wflow_use_gitlab}. This is
  currently for internal use only. Please open an Issue if you'd like to use
  this information.
}
\description{
\code{wflow_use_gitlab} automates all the local configuration necessary to
deploy your workflowr project with
\href{https://docs.gitlab.com/user/project/pages/}{GitLab Pages}.
Afterwards, you will need to run \code{wflow_git_push} in the R console (or
\code{git push} in the terminal) to push the code to GitLab. Note that this
will also create the repository if it doesn't exist yet (this requires GitLab
10.5 or greater). Alternatively, you could manually login to your account and
create the new repository on GitLab prior to pushing.
}
\details{
\code{wflow_use_gitlab} performs the following steps and then commits the
changes:

\itemize{

\item Renames the website directory from \code{docs/} to \code{public/}

\item Edits the setting \code{output_dir} in the file \code{_site.yml} to
save the website files in \code{public/}

\item Adds a link to the GitLab repository in the navigation bar

\item Creates the required file \code{.gitlab-ci.yml}

\item Configures the Git remote settings to use GitLab

}

By default the GitLab repository is set to private, so you are the only one
that can access it. If you need to keep it private, you can
\href{https://gitlab.com/help/user/project/pages/pages_access_control.md}{grant
access} to collaborators in Settings->Members. Otherwise, you can make it
public in Settings->General->Visibility.

For more details, read the documentation provided by
\href{https://docs.gitlab.com/user/project/pages/}{GitLab Pages}.
}
\examples{
\dontrun{

wflow_use_gitlab("your-username", "name-of-repository")
# Login with GitLab account and create new repository
wflow_git_push()
}

}
\seealso{
\code{\link{wflow_git_push}}, \code{\link{wflow_git_remote}},
         \code{\link{wflow_use_github}}, vignette("wflow-06-gitlab")
}
