#' jtrain98
#'
#' Wooldridge Source: This is a data set I created many years ago intended as an update to the files JTRAIN2 and JTRAIN3. While the data were partly generated by me, the data attributes are similar to data sets used to evaluate job training programs. Data loads lazily.
#'
#' @section Notes: The response variables, earn98 and unem98, both have discreteness: the former is a corner solutions (takes on the value zero and then a range of strictly positive values) and the latter is binary. One could use these in an exercise using methods in Chapter 17. unem98 can be used in a probit or logit model, earn98 in a Tobit model, or in Poisson regression (without assuming, of course, that the Poisson distribution is correct).
#'
#' Used in Text: 101-102, 248, 601
#'
#' @docType data
#'
#' @usage data('jtrain98')
#'
#' @format A data.frame with 1130 observations on 10 variables:
#' \itemize{
#'  \item \strong{train: } =1 if in job training
#'  \item \strong{age: } in years
#'  \item \strong{educ: } years of schooling
#'  \item \strong{black: } =1 if black
#'  \item \strong{hisp: } =1 if Hispanic
#'  \item \strong{married: } =1 if married
#'  \item \strong{earn96: } earnings in 1996, $1000s
#'  \item \strong{unem96: } =1 if unemployed all of 1995
#'  \item \strong{earn98: } earnings in 1998, $1000s
#'  \item \strong{unem98: }=1 if unemployed all of 1998
#' }
#' @source \url{http://www.cengage.com/c/introductory-econometrics-a-modern-approach-7e-wooldridge}
#' @examples  str(jtrain98)
"jtrain98"
 
 
