% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qk_coeff.R
\name{qk_coeff}
\alias{qk_coeff}
\title{Coefficient Matrix \eqn{\mathcal{C}_k}}
\usage{
qk_coeff(k, alpha = 2)
}
\arguments{
\item{k}{The order of the \eqn{\mathcal{C}_k} matrix}

\item{alpha}{The type of Wishart distribution (\eqn{\alpha=2/\beta}):
\itemize{
\item 1/2: Quaternion Wishart
\item 1: Complex Wishart
\item 2: Real Wishart (default)
}}
}
\value{
\eqn{\mathcal{C}_k}, a matrix that allows us to obtain \eqn{E[p_{\lambda}(W)W^r]},
where \eqn{r+|\lambda|=k} and \eqn{W \sim W_m^{\beta}(n, \Sigma)}.
The matrix is represented as a 3-dimensional array where each slice along the third
dimension represents a coefficient matrix of the polynomial in descending powers of \eqn{n}.
}
\description{
This function computes the coefficient matrix \eqn{\mathcal{C}_k}, which
is a matrix of constants that allows us to obtain \eqn{E[p_{\lambda}(W)W^r]},
where \eqn{r+|\lambda|=k} and \eqn{W \sim W_m^{\beta}(n, \Sigma)}.
}
\examples{
# Example 1:
qk_coeff(2) # For real Wishart distribution with k = 2

# Example 2:
qk_coeff(3, 1) # For complex Wishart distribution with k = 3

# Example 3:
qk_coeff(2, 1/2) # For quaternion Wishart distribution with k = 2

}
